package gov.va.med.domain.service.messaging;

import gov.va.med.domain.model.IPayload;
import gov.va.med.domain.service.messaging.parse.HL7MessageMetadata;

/**
 * Request
 *
 * @author Odysseas Pentakalos
 * @version $Id: Request.java,v 1.3 2005/04/21 21:31:08 slava.uchitel Exp $
 * @since MHV 2.0 <br>Mar 1, 2005
 */
public class Request extends Message {

	private static final long serialVersionUID = 3258133561403191608L;
	private long userId;

	public Request(MessageType messageType, IPayload payload) {
		super(messageType, payload);
	}
	/** 
	 * Digger method to get the function name from the MessageType
	 */
	public String getFunctionName() {
	    return getMessageType().getRemoteFunctionName();
	    }
	public long getUserId() {return userId;}
	public void setUserId(long userId) {this.userId = userId;}
    
	public boolean isApplicationAckRequest()	
	{
	    // If payload is metadata - it is resulted from incoming message that requires application ack.
	    return (this.getPayload() instanceof HL7MessageMetadata); 
	}
	
}
